/*
 * xwindow.h - macros and types used in X-Icon.
 */

#ifndef MAXXOBJS
#define MAXXOBJS 256
#endif					/* MAXXOBJS */


#ifdef PresentationManager
/* don't want to include this if we are making the translator */
#ifndef ICONT
/* pull in variable arg lists */
#include <stdarg.h>
/* have to knock out the fprintf */
#undef fprintf
#define fprintf PMfprintf
/* have to knock out putc also */
#undef putc
#define putc PMputc
#endif					/* ICONT */

/* the interpreter thread stack size - make it really big since this will
   grow dynamically */
#define THREADSTACKSIZE      512000
/* special events for window creation/communication between threads */
#define NEW_WINDOW           (WM_USER)
#define REQUEST_WINDOW       (WM_USER + 1)
#define REQUEST_DESTROY      (WM_USER + 2)
#define DESTROYED_WINDOW     (WM_USER + 3)
#define WINDOW_SIZED         (WM_USER + 4)
#define ASCII_CHAR           (WM_USER + 5)
#define VIRT_KEY             (WM_USER + 6)
#define MOUSE_EVENT          (WM_USER + 7)

/* these are the bounds for the events that we want the interp thread
   to pick up for the */
#define INTERP_EVENT_START     WINDOW_SIZED
#define INTERP_EVENT_END       MOUSE_EVENT
/* whether you should block waiting for an event or not */
#define WAIT_EVT             1
#define NO_WAIT_EVT          0
/* gemeotry bitmasks */
#define GEOM_WIDTH           1
#define GEOM_HEIGHT          2
#define GEOM_POSX            4
#define GEOM_POSY            8
/* wonderful define to get around RTT */
#define MRESULT_N_EXPENTRY   MRESULT EXPENTRY
/* mutual exclusion */
#define MAXWAIT              500
#define INFINITE_WAIT         -1
/* initial dependants allocated for context/window bundles */
#define INITDEPS             32
/* fill styles */
#define FS_SOLID             1
#define FS_STIPPLE           2
#define FS_OPAQUESTIPPLE     4
/* the special ROP code for mode reverse */
#define ROP_USER1            (ROP_ONE << 1)
/* window state */
#define WS_NORMAL            0
#define WS_MIN               1
#define WS_MAX               2

/* arguments to be passed to secondary thread */
typedef struct {
  char **argv;
  int argc;
  } threadargs;
#endif					/* PresentationManager */

#ifndef PresentationManager
/*
 * Macros to ease coding in which every X call must be done twice.
 */
#define RENDER2(func,v1,v2) {\
   if (stdwin) func(stddpy, stdwin, stdgc, v1, v2); \
   func(stddpy, stdpix, stdgc, v1, v2);}
#define RENDER3(func,v1,v2,v3) {\
   if (stdwin) func(stddpy, stdwin, stdgc, v1, v2, v3); \
   func(stddpy, stdpix, stdgc, v1, v2, v3);}
#define RENDER4(func,v1,v2,v3,v4) {\
   if (stdwin) func(stddpy, stdwin, stdgc, v1, v2, v3, v4); \
   func(stddpy, stdpix, stdgc, v1, v2, v3, v4);}
#define RENDER6(func,v1,v2,v3,v4,v5,v6) {\
   if (stdwin) func(stddpy, stdwin, stdgc, v1, v2, v3, v4, v5, v6); \
   func(stddpy, stdpix, stdgc, v1, v2, v3, v4, v5, v6);}

/*
 * Macros to perform direct window system calls from graphics routines
 */
#ifdef XWindows
#define drawarcs(w, arcs, narcs) \
   { STDLOCALS(w); RENDER2(XDrawArcs,arcs,narcs); }
#define drawlines(w, points, npoints) \
   { STDLOCALS(w); RENDER3(XDrawLines,points,npoints,CoordModeOrigin); }
#define drawpoints(w, points, npoints) \
   { STDLOCALS(w); RENDER3(XDrawPoints,points,npoints,CoordModeOrigin); }
#define drawrectangles(w, recs, nrecs) { \
   STDLOCALS(w); \
   for(i=0; i<nrecs; i++) { \
     RENDER4(XDrawRectangle,recs[i].x,recs[i].y,recs[i].width,recs[i].height);\
     }}

#define drawsegments(w, segs, nsegs) \
   { STDLOCALS(w); RENDER2(XDrawSegments,segs,nsegs); }
#define drawstring(w, x, y, s, slen) \
   { STDLOCALS(w); RENDER4(XDrawString, x, y, s, slen); }
#define fillarcs(w, arcs, narcs) \
   { STDLOCALS(w); RENDER2(XFillArcs, arcs, narcs); }
#define fillpolygon(w, points, npoints) \
   { STDLOCALS(w); RENDER4(XFillPolygon, points, npoints, Complex, CoordModeOrigin); }
#define fillrectangles(w, recs, nrecs) \
   { STDLOCALS(w); RENDER2(XFillRectangles, recs, nrecs); }

#endif					/* XWindows */
#else					/* PresentationManager */
/* some macros for PresentationManager */
#define MutexOn(ws) { if (ws->mutex) DosRequestMutexSem(ws->mutex, INFINITE_WAIT); }
#define MutexOff(ws) { if (ws->mutex) DosReleaseMutexSem(ws->mutex); }
#define MAKERGB(r,g,b) ((ULONG)(((r) << 16) | ((g) << 8) | (b)))
#define RGB16TO8(x) if ((x) > 0xff) (x) = (((x) >> 8) & 0xff)
#define AddPatternDependant(id)  AddLocalIdDependant((id))
#define ReleasePattern(id)  ReleaseLocalId((id))
#define AddFontDependant(id)  AddLocalIdDependant((id))
#define ReleaseFont(id)  ReleaseLocalId((id))
#define AddFontToWindow(ws, id) AddLocalIdToWindow((ws), (id))
#define AddPatternToWindow(ws, id) AddLocalIdToWindow((ws), (id))
#define HideCursor(ws) if ((ws)->hpsWin && ISCURSORONW(ws) &&  \
                           ws->hwnd == WinQueryFocus(HWND_DESKTOP)) \
                         WinShowCursor((ws)->hwnd, 0);
#define ShowCursor(ws) if ((ws)->hpsWin && ISCURSORONW(ws) && \
                           ws->hwnd == WinQueryFocus(HWND_DESKTOP)) \
                         WinShowCursor((ws)->hwnd, 1);
#endif 					/* PresentationManager */


/*
 * EVENT HANDLING
 *
 * Each window keeps an associated queue of events waiting to be
 * processed.  The queue consists of <eventcode,x,y> triples,
 * where eventcodes are strings for normal keyboard events, and
 * integers for mouse and special keystroke events.
 *
 * The main queue is an icon list.  In addition, there is a queue of
 * old keystrokes maintained for cooked mode operations, maintained
 * in a little circular array of chars.
 */
#define MOD_CONTROL (1<<16)
#define MOD_META    (1<<17)
#define MOD_SHIFT   (1<<18)

#ifndef PresentationManager
/* get now means remove them from the Icon list and put them on the ghost que*/
#define EVQUEGET(w,d) { \
  int i;\
  wsp ws = (w)->window; \
  if (!c_get((struct b_list *)BlkLoc(ws->listp),&d)) fatalerr(0,NULL); \
  if (Qual(d)) {\
      ws->eventQueue[ws->eQfront++] = *StrLoc(d); \
      if (ws->eQfront >= EQUEUELEN) ws->eQfront = 0; \
      ws->eQback = ws->eQfront; \
      } \
  }
#define EVQUEEMPTY(w) (BlkLoc((w)->window->listp)->list.size == 0)
#else					/* PresentationManager */
/* get now means remove them from the Icon list and put them on the ghost que*/
#define EVQUEGET(ws,d) { \
  int i;\
  if (!c_get((struct b_list *)BlkLoc((ws)->listp),&d)) fatalerr(0,NULL); \
  if (Qual(d)) {\
      ws->eventQueue[(ws)->eQfront++] = *StrLoc(d); \
      if ((ws)->eQfront >= EQUEUELEN) (ws)->eQfront = 0; \
      (ws)->eQback = (ws)->eQfront; \
      } \
  }
#define EVQUEEMPTY(ws) (BlkLoc((ws)->listp)->list.size == 0)
/* the maximum number of messages to be queued by PM */
#define MAXMSGS  25
#endif					/* PresentationManager */
#define EVQUESUB(w,i) *evquesub(w,i)
#define EQUEUELEN 256
#define MARGIN 0

/*
 * mode bits for the Icon window context (as opposed to X context)
 */

#ifndef PresentationManager
#define ISZOMBIE(w)     ((w)->window->bits & 1)
#else					/* PresentationManager */
#define ISINITIAL(w)    ((w)->window->bits & 1)
#define ISINITIALW(w)   ((w)->bits & 1)
#endif					/* PresentationManager */
#define ISCURSORON(w)   ((w)->window->bits & 2)
#ifdef PresentationManager
#define ISCURSORONW(ws) ((ws->bits) & 2)
#endif					/* PresentationManager */
#ifdef XBATCH
#define ISBATCHMODE(w)  ((w)->window->bits & 4)
#endif				/* XBATCH */
#define ISREVERSE(w)    ((w)->context->bits & 8)
#define ISXORREVERSE(w)	((w)->context->bits & 16)
#define ISXORREVERSEW(w) ((w)->bits & 16)
#define ISEXPOSED(w)    ((w)->window->bits & 256)
#define ISCEOLON(w)     ((w)->window->bits & 512)
#define ISECHOON(w)     ((w)->window->bits & 1024)
#ifdef PresentationManager
#define ISMINPEND(w)    ((w)->window->bits & 2048)
#define ISMINPENDW(w)   ((w)->bits & 2048)
#endif					/* PresentationManager */

#ifndef PresentationManager
#define SETZOMBIE(w)    ((w)->window->bits |= 1)
#else					/* PresentationManager */
#define SETINITIAL(w)   ((w)->window->bits |= 1)
#endif					/* PresentationManager */
#define SETCURSORON(w)  ((w)->window->bits |= 2)
#ifdef XBATCH
#define SETBATCHMODE(w) ((w)->window->bits |= 4)
#endif				/* XBATCH */
#define SETREVERSE(w)   ((w)->context->bits |= 8)
#define SETXORREVERSE(w) ((w)->context->bits |= 16)
#define SETEXPOSED(w)   ((w)->window->bits |= 256)
#define SETCEOLON(w)    ((w)->window->bits |= 512)
#define SETECHOON(w)    ((w)->window->bits |= 1024)
#ifdef PresentationManager
#define SETMINPEND(w)   ((w)->window->bits |= 2048)
#endif					/* PresentationManager */

#ifndef PresentationManager
#define CLRZOMBIE(w)    ((w)->window->bits &= ~1)
#else					/* PresentationManager */
#define CLRINITIAL(w)   ((w)->window->bits &= ~1)
#define CLRINITIALW(w)  ((w)->bits &= ~1)
#endif					/* PresentationManager */
#define CLRCURSORON(w)  ((w)->window->bits &= ~2)
#ifdef XBATCH
#define CLRBATCHMODE(w) ((w)->window->bits &= ~4)
#endif				/* XBATCH */
#define CLRREVERSE(w)   ((w)->context->bits &= ~8)
#define CLRXORREVERSE(w) ((w)->context->bits &= ~16)
#define CLREXPOSED(w)   ((w)->window->bits &= ~256)
#define CLRCEOLON(w)    ((w)->window->bits &= ~512)
#define CLRECHOON(w)    ((w)->window->bits &= ~1024)
#ifdef PresentationManager
#define CLRMINPEND(w)   ((w)->window->bits &= ~2048)
#define CLRMINPENDW(w)  ((w)->bits &= ~2048)
#endif					/* PresentationManager */

/*
 * Window Resources
 * Icon "Resources" are a layer on top of the window system resources,
 * provided in order to facilitate resource sharing and minimize the
 * number of calls to the window system.  Resources are reference counted.
 * These data structures are simple sets of pointers
 * into internal window system structures.
 *
 * The following constants define limitations in the system, gradually being
 * removed as this code is rewritten to use dynamic allocation.
 */
#ifndef PresentationManager
#define DMAXCOLORS	256
#define WMAXCOLORS	256
#define MAXCOLORNAME	24
#define MAXDISPLAYNAME	24
#define MAXLABEL	24
#define SHARED          0
#define MUTABLE         1
#define NUMCURSORSYMS	78
#else					/* PresentationManager */
#define MAXLABEL	128
#endif					/* PresentationManager */


#ifndef PresentationManager
/*
 * Colors.  These are allocated within displays; they are currently
 * statically bounded to DMAXCOLORS colors per display.  Pointers
 * into the display's color table are also kept on a per-window
 * basis so that they may be (de)allocated when a window is cleared.
 * Colors are aliased by r,g,b value.  Allocations by name and r,g,b
 * share when appropriate.
 *
 * Color (de)allocation comprises a simple majority of the space
 * requirements of the current implementation.  A monochrome-only
 * version would take a lot less space.
 *
 * The name field is the string returned by XAttrib.  For a mutable
 * color this is of the form "-47" followed by a second C string
 * containing the current color setting.
 */
typedef struct {
  int		refcount;
  char		name[6+MAXCOLORNAME];	/* name for XAttrib & XColor reads */
  unsigned short r, g, b;		/* rgb for colorsearch */
  unsigned long	c;			/* X pixel value */
  int           type;			/* SHARED or MUTABLE */
} wcolor, *wclrp;
#else					/* PresentationManager */

/* Colors... */
#define CLR_LOCKED      1
#define CLR_USED        2
#define CLR_BASE        4

/* constant used to offset entries in global table *over* the standard colors */
typedef struct _CNODE {
  ULONG		bits;                    /* flags */
  int		refcount;                /* reference count */
  ULONG		rgb;                     /* the rgb component */
  struct _CNODE *next, *previous;
  } colorEntry;
#endif					/* PresentationManager */

/*
 * Fonts are allocated within displays.
 */
typedef struct wfont {
#ifndef PresentationManager  
  int		refcount;
  char	      *	name;			/* name for XAttrib and fontsearch */
  int		height;			/* font height */
  int		leading;		/* inter-line leading */
#ifdef XWindows
  XFontStruct *	fsp;			/* X font pointer */
#endif					/* XWindows */
  struct wfont *previous, *next;
#else					/* PresentationManager */
/* XXX replace this HUGE structure with single fields later - when we know
   conclusively which ones we need */
  FONTMETRICS	metrics;		/* more than you ever wanted to know */
#endif					/* PresentationManager */
} wfont, *wfp;

#ifdef PresentationManager
/* Presentation space local id's are used to identify fonts, bitmaps
   and markers.  Since we have 2 presentation spaces for each window,
   and contexts can be associated with different windows through bindings,
   the local identifier map must be identical throughout all ps (since the
   context can identify a font as ID 2 on one space and that must be valid
   on each space it is bound to).  This will be handled by a global array
   of lclIdentifier */
#define MAXLOCALS               255
#define IS_FONT                 1
#define IS_PATTERN              2
#define IS_MARKER               4               /* unused for now */

typedef struct _lclIdentifier {
  SHORT idtype;         /* type of the id, either font or pattern */
  SHORT refcount;       /* reference count, when < 1, deleted */
  union {
     wfont font;        /* font info */
     HBITMAP hpat;      /* pattern bitmap handle */
     } u;
  struct _lclIdentifier *next,          /* dbl linked list */
                        *previous;
  } lclIdentifier;
#endif					/* PresentationManager */

#ifndef PresentationManager
/*
 * Displays are maintained in a global list in rwinrsc.r.
 */
typedef struct wdisplay {
  int		refcount;
  char		name[MAXDISPLAYNAME];
#ifdef XWindows
  Display *	display;
  GC		icongc;
  Colormap	cmap;
  int		screen;
#endif					/* XWindows */
  int		numFonts;
  wfp		fonts;
  int           numColors;		/* allocated color info */
  wcolor	colors[DMAXCOLORS];
  Cursor	cursors[NUMCURSORSYMS];
  struct wdisplay *previous, *next;
} wdisplay, *wdp;

extern struct wdisplay * wdsplys;
#endif					/* PresentationManager */

/*
 * "Context" comprises the graphics context, and the font (i.e. text context).
 * Foreground and background colors (pointers into the display color table)
 * are stored here to reduce the number of window system queries.
 * Contexts are allocated out of a global array in rwinrsrc.c.
 */
typedef struct wcontext {
  int		refcount;
#ifndef PresentationManager
  wdp		display;
#ifdef XWindows
  GC		gc;			/* X graphics context */
#endif					/* XWindows */
  wclrp		fg, bg;
  int		linestyle;
  int		linewidth;
#else					/* PresentationManager */
  /* attribute bundles */
  CHARBUNDLE	charBundle;		/* text attributes */
  LINEBUNDLE	lineBundle;		/* line/arc attributes */
  AREABUNDLE	areaBundle;		/* polygon attributes... */
  IMAGEBUNDLE	imageBundle;		/* attributes use in blit of mono bms */
  LONG 		fntLeading;		/* external leading for font - user */
  SHORT		currPattern;		/* id of current pattern */
  LONG		numDeps;		/* number of window dependants */
  LONG		maxDeps;		/* maximum number of deps in current table */
  struct wstate **depWindows;           /* array of window dependants */
#endif					/* PresentationManager */
  int		clipx, clipy, clipw, cliph;
  wfp		font;
  int		dx, dy;
  int		fillstyle;
  int		drawop;
  int		bits;			/* context bits */
  struct wcontext *previous, *next;
} wcontext, *wcp;

/*
 * "Window state" includes the actual X window and references to a large
 * number of resources allocated on a per-window basis.  Windows are
 * allocated out of a global array in rwinrsrc.c.  Windows remember the
 * first WMAXCOLORS colors they allocate, and deallocate them on clearscreen.
 */
typedef struct wstate {
  int		refcount;		/* reference count */
#ifndef PresentationManager
  wdp		display;
#ifdef XWindows
  Window	win;			/* X window */
  Pixmap	pix;			/* current screen state */
  Pixmap	prepix;			/* an initial image to display */
  Window        parent;			/* parent window */
  Window        iconwin;		/* icon window */
  Pixmap	iconpix;		/* icon pixmap */
#endif					/* XWindows */
  int		ellipse_oldx;           /* used in ellipse outlines */
  int		pixheight;		/* pixmap height, in pixels */
  int		pixwidth;		/* pixmap width, in pixels */
  wclrp		winbg;			/* window background color */
  int           numColors;		/* allocated color info */
  short		theColors[WMAXCOLORS];	/* indices into display color table */
  int		iconic;		/* window state; icon, window or root */
  int		iconx, icony;           /* location of icon */
  int		iconw, iconh;		/* width and height of icon */
  char		iconimage[MaxFileName];	/* icon pixmap file name */
  char		iconlabel[MAXLABEL];	/* icon label */
  char		windowlabel[MAXLABEL];	/* window label */
  long wmhintflags;			/* window manager hints */
#else					/* PresentationManager */
  HWND		hwnd;			/* handle to the window (client) */
  HWND		hwndFrame;		/* handle to the frame window */
  HMTX		mutex;			/* window access mutex sem */
  HDC		hdcWin;
  HPS		hpsWin;
  HPS		hpsBitmap;
  HBITMAP	hBitmap;		/* handle to the backing bitmap */
  HDC		hdcBitmap;		/* handle to the bit, memory DC */
  int 		bitHeight;		/* backing bitmap height */
  int		bitWidth;		/* backing bitmap width */
  wcontext	*charContext;		/* context currently loaded in PS's */
  wcontext	*lineContext;		
  wcontext 	*areaContext;
  wcontext	*imageContext;
  wcontext	*clipContext;
  LONG 		winbg;			/* window background color */
  HBITMAP	hInitialBitmap;	/* the initial image to display */
  HPOINTER	hPointer;		/* handle to window's current pointer */
  CURSORINFO	cursInfo;		/* cursor information stored on lose focus */
  LONG		numDeps;		/* number of context dependants */
  LONG		maxDeps;
  wcontext      **depContexts;          /* array of context dependants */
  /* XXX I don't like this below, but it will do for now - until I figure
     out something better.  Following the charContext pointer to find the
     descender value is not enough as it could be NULL */
  SHORT         lastDescender;          /* the font descender value from last wc */
  HRGN		hClipWindow;		/* clipping regions */
  HRGN		hClipBitmap;
  BYTE		winState;               /* window state: icon, window, maximized */
  HBITMAP       hIconBitmap;
  char          *szIconFileName;
  char		*szTitleWhenWindow;
  char		*szTitleWhenIcon;
#endif					/* PresentationManager */
  int		y, x;			/* current cursor location, in pixels*/
  int		pointery,pointerx;	/* current mouse location, in pixels */
  int		posy, posx;		/* desired upper lefthand corner */
  int		height;			/* window height, in pixels */
  int		width;			/* window width, in pixels */
  int		bits;			/* window bits */
  int		theCursor;		/* index into cursor table */
  char		eventQueue[EQUEUELEN];  /* queue of cooked-mode keystrokes */
  int		eQfront, eQback;
  struct descrip filep, listp;		/* icon values for this window */
  struct wstate *previous, *next;
} wstate, *wsp;

/*
 * Icon window file variables are actually pointers to "bindings"
 * of a window and a context.  They are allocated out of a global
 * array in rwinrsrc.c.  There is one binding per Icon window value.
 */
typedef struct wbinding {
  int refcount;
  wcp context;
  wsp window;
  struct wbinding *previous, *next;
} wbinding, *wbp;

extern struct wbinding * wbndngs;

/*
 * Some structures used by graphics routines, for non-X systems
 */
#ifndef XWindows

#ifdef MSWindows
typedef struct {
    short x1, y1, x2, y2;
} XSegment;
#endif					/* MSWindows */

/* we make the segment structure look like this so that we can
   cast it to POINTL structures that can be passed to GpiPolyLineDisjoint */
#ifdef PresentationManager
typedef struct {
  LONG x1, y1;
  LONG x2, y2;
  } XSegment;
#endif					/* PresentationManager */

#ifdef MSWindows
#define XPoint POINT
#endif					/* MSWindows */

#ifdef PresentationManager
typedef POINTL XPoint;
#endif					/* PresentationManager */

#ifdef PresentationManager
typedef RECTL XRectangle;
#endif					/* PresentationManager */

#ifdef MSWindows
typedef struct {
    short x, y;
    unsigned short width, height;
} XRectangle;
#endif					/* MSWindows */

#ifdef MSWindows
typedef struct {
    short x, y;
    unsigned short width, height;
    short angle1, angle2;
} XArc;
#endif					/* MSWidnwos */

#ifdef PresentationManager
typedef struct {
  LONG x, y;
  ARCPARAMS arcp;
  FIXED angle1, angle2;
  } XArc;
#endif					/* PresentationManager */
#endif					/* XWindows */

/*
 * macros performing row/column to pixel y,x translations
 * computation is 1-based and depends on the current font's size.
 * exception: XTOCOL as defined is 0-based, because that's what its
 * clients seem to need.
 */
#ifndef PresentationManager
#define ROWTOY(w,row) ((row-1) * w->context->font->leading + \
		       w->context->font->fsp->max_bounds.ascent + MARGIN)
#define COLTOX(w,col) ((col-1) * w->context->font->fsp->max_bounds.width + \
		       MARGIN)
#define YTOROW(w,y)   (((y) - MARGIN) / w->context->font->leading + 1)
#define XTOCOL(w,x)   (((x) - MARGIN) / w->context->font->fsp->max_bounds.width)

#define STDLOCALS(w) \
   wcp wc = (w)->context; \
   wsp ws = (w)->window; \
   wdp wd = ws->display; \
   GC      stdgc  = wc->gc; \
   Display *stddpy = wd->display; \
   Window  stdwin  = ws->win; \
   Pixmap  stdpix  = ws->pix;

wclrp alc_color			Params((wbp w,char *s));
wdp alc_display			Params((char *s));
wfp alc_font			Params((wbp w, char **s));

#else					/* PresentationManager */
#define ROWTOY(wb, row)  ((row - 1) * (wb->context->fntLeading +  \
                          wb->context->font->metrics.lMaxBaselineExt) + \
                          MARGIN + wb->context->font->metrics.lMaxAscender)
#define COLTOX(wb, col)  ((col - 1) * \
                          wb->context->font->metrics.lMaxCharInc + \
                          MARGIN)
#define YTOROW(wb, y)    (((y) - MARGIN) /  (wb->context->fntLeading + \
                          wb->context->font->metrics.lMaxBaselineExt) + 1)
#define XTOCOL(wb, x)    (((x) - MARGIN) /  \
                          wb->context->font->metrics.lMaxCharInc)
/* system size values */
#define BORDERWIDTH      (WinQuerySysValue(HWND_DESKTOP, SV_CXSIZEBORDER))
#define BORDERHEIGHT     (WinQuerySysValue(HWND_DESKTOP, SV_CYSIZEBORDER))
#define TITLEHEIGHT      (WinQuerySysValue(HWND_DESKTOP, SV_CYTITLEBAR))

#define STDLOCALS(w) \
   wcontext *wc = (w)->context; \
   wstate *ws = (w)->window; \
   HPS stdwin = ws->hpsWin; \
   HPS stdbit = ws->hpsBitmap;
#endif					/* PresentationManager */

wcp alc_context			Params((wbp w));
novalue setclip			Params((wbp w));
wsp alc_winstate();
wbp alc_wbinding();

typedef struct {
  char *s;
  int i;
} stringint, *siptr;

#ifndef PresentationManager
extern stringint drawops[], cursorsyms[];
#endif					/* PresentationManager */
extern stringint attribs[];
extern char *si_i2s();
extern int si_s2i();

/*
 * Attributes
 */

#define A_ASCENT	3
#define A_BATCH		1
#define A_BG		2
#define A_CEOL		47
#define A_CLIPH		52
#define A_CLIPX		49
#define A_CLIPY		50
#define A_CLIPW		51
#define A_COL		4
#define A_COLUMNS	5
#define A_CURSOR	6
#define A_DESCENT	39
#define A_DEPTH		7
#define A_DISPLAY	8
#define A_DISPLAYHEIGHT	9
#define A_DISPLAYWIDTH	10
#define A_DRAWOP	12
#define A_DX		48
#define A_DY		13
#define A_ECHO		46
#define A_FG		14
#define A_FHEIGHT	15
#define A_FILLSTYLE	16
#define A_FONT		17
#define A_FWIDTH	18
#define A_GEOMETRY	19
#define A_HEIGHT	20
#define A_ICONIC	23
#define A_ICONIMAGE     42
#define A_ICONLABEL	43
#define A_ICONPOS	21
#define A_IMAGE		22
#define A_LEADING	45
#define A_LINES		24
#define A_LINESTYLE	25
#define A_LINEWIDTH	26
#define A_POINTERCOL	27
#define A_POINTERROW	28
#define A_POINTERX	29
#define A_POINTERY	30
#define A_POINTER	32
#define A_POS		33
#define A_POSX		31
#define A_POSY		11
#define A_REVERSE	35
#define A_ROW		34
#define A_TEXTWIDTH	36
#define A_VISUAL	40
#define A_WIDTH		41
#define A_WINDOWLABEL   44
#define A_X		37
#define A_Y		38

#define NUMATTRIBS	52

#define XICONSLEEP	20000 /* microseconds */

/* XXX move these to rproto.h */
#ifdef PresentationManager
int ObtainEvents(wstate *ws, SHORT blockflag);
void InterpThreadStartup(void *args);
FILE *WinOpen(char *winname, struct b_list *lp, dptr attr, int n);
void DestroyWindow(wstate *ws);
void LoadDefAttrs(wbinding *wb, wstate *ws, wcontext *wc);
void ResizeBackingBitmap(wstate *ws, SHORT x, SHORT y);
int SetNewBitPattern(wcontext *wc, PBYTE bits);
int SetPattern(wcontext *wc, char *name, int len);
int SetFont(wcontext *wc, char *family, LONG attr, LONG fontsize);
int ParseFontSpec(char *rawdata, char *family, LONG *flags, LONG *size);
void FreeLocalID(LONG id);
void SetCharContext(wbinding *wb, wstate *ws, wcontext *wc);
void SetAreaContext(wbinding *wb, wstate *ws, wcontext *wc);
void SetLineContext(wbinding *wb, wstate *ws, wcontext *wc);
void SetImageContext(wbinding *wb, wstate *ws, wcontext *wc);
void SetClipContext(wbinding *wb, wstate *ws, wcontext *wc);
void UnsetCharContext(wcontext *wc);
void UnsetLineContext(wcontext *wc);
void UnsetAreaContext(wcontext *wc);
void UnsetImageContext(wcontext *wc);
void UnsetClipContext(wcontext *wc);
void UnsetAllContext(wcontext *wc);
void drawlines(wbinding *wb, XPoint *pts, int npts);
void drawCurve(wbinding *wb, XPoint *pts, int npts);
void drawpoints(wbinding *wb, XPoint *pts, int npts);
void drawsegments(wbinding *wb, XSegment *segs, int nsegs);
void drawstring(wbinding *wb, int x, int y, char *str, int slen);
void fillrectangles(wbinding *wb, XRectangle *recs, int nrecs);
void drawrectangles(wbinding *wb, XRectangle *recs, int nrecs);
void fillpolygon(wbinding *wb, XPoint *pts, int npts);
int dumpimage(wbinding *wb, char *filename, int x, int y, int width, int height);
HBITMAP loadimage(wbinding *wb, char *filename, int *width, int *height);
void InitializeColorTable(void);
LONG GetRGBColorIndex(ULONG rgb);
void AddColorDependant(LONG indx);
void AddLocalIdToWindow(wstate *ws, LONG id);
void ReleaseLocalId(LONG id);
void ReleaseColor(LONG indx);
void ColorInitPS(wbinding *wb);
void GetColorName(LONG indx, char *buf, int len);
LONG ParseRGBValue(char *buf);
void EnsureColorAvailable(LONG indx);
int GetTextWidth(wbinding *wb, char *text, int len);
int AddWindowDep(wstate *ws, wcontext *wc);
int AddContextDep(wstate *ws, wcontext *wc);
FILE *OpenConsole(void);
void UpdateCursorConfig(wstate *ws, wcontext *wc);
void UpdateCursorPos(wstate *ws, wcontext *wc);
ULONG ParseGeometry(char *buf, SHORT *x, SHORT *y, SHORT *width, SHORT *height);
int PMfprintf(FILE *file, char *format, ...);
int PMputc(int c, FILE *file);

extern FILE *ConsoleBinding;
#endif					/* PresentationManager */

